using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using ComiDll;
using System.Runtime.InteropServices;

namespace ADCcon
{
    public partial class Form1 : Form
    {
        IntPtr g_hDevice = IntPtr.Zero;
        public bool g_bScanStart = false;
        public const int BufSize = 10240;
        public bool single1 = true;
        public const int CH_NUM = 6; // AD ĵ ϴ ä 

        double[] g_fData = new double[1000];

        public enum CHLIST
        {
            CH0, CH1, CH2, CH3, CH4, CH5
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            g_hDevice = CDDLL.COMI_LoadDevice((int)CDDLL.TCmDeviceID.COMI_SD101, 0);

            if (g_hDevice == IntPtr.Zero) MessageBox.Show("Device SD101 ε ");
        }

        private void BtnStop_Click(object sender, EventArgs e)
        {
            //  ȯBuffer   Continuous A/D  C#(.NET)   ϵ     Ұ մϴ.
            //CDDLL.COMI_US_Stop(g_hDevice, 1);
            g_bScanStart = false;
            timer1.Enabled = true;
        }

        private void CmbCh_SelectedIndexChanged(object sender, EventArgs e)
        {
            axComiGraph1.TargetChannel = 0;
            axComiGraph1.ChannelTitle = CmbCh.Text;
            axComiGraph1.RefreshAll();
        }

        private void EdtFreq_TextChanged(object sender, EventArgs e)
        {
            //if (EdtFreq.Text.Length==0)
            //{
            //    EdtFreq.Text = convert.100;
            //}
            //else if (EdtFreq.Text > 1000)
            //{
            //    EdtFreq.Text = "1000";
            //}
            //else if (EdtFreq.Text < 0)
            //{
            //    EdtFreq.Text = "100";
            //}
        }

        private void BtnStart_Click(object sender, EventArgs e)
        {
            timer1.Interval = 15;
            timer1.Enabled = true;
            
            /*  ȯBuffer   Continuous A/D  C#(.NET)   ϵ     Ұ մϴ.
            int i;
            int ScanFreq = Convert.ToInt32(this.EdtFreq.Text);
            int nResult = 0;

            int []ChannelList = new int [CH_NUM];

            for (i = 0; i< CH_NUM; i++)
            {
                ChannelList[i] = i;
            }

            try
            {
                
                nResult = CDDLL.COMI_US_Start(g_hDevice, CH_NUM, ChannelList, ScanFreq, BufSize, (int)CDDLL.TCdAiScanTrs.cmTRS_SINGLE);

                if (nResult > 0) // nResult   scan freq  ȯ
                {
                    g_bScanStart = true;
                }
                else
                {
                    MessageBox.Show("Aiscan    ");
                }
            }
            catch
            {
                MessageBox.Show("AiscanstartԼ ߻");
            }
            */
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            double[] afData = new double[CH_NUM];

            afData[CmbCh.SelectedIndex] = CDDLL.COMI_AD_GetVolt(g_hDevice, CmbCh.SelectedIndex);

            lblData.Text = afData[0].ToString();

            // ׷ ǥ
            axComiGraph1.DeletePlot(CmbCh.SelectedIndex);
            axComiGraph1.PlotY(CmbCh.SelectedIndex, ref afData[CmbCh.SelectedIndex], 0, 1, 1);
            axComiGraph1.UpdatePlot();

            /*  ȯBuffer   Continuous A/D  C#(.NET)   ϵ     Ұ մϴ.
             
            if (!g_bScanStart) return;

            IntPtr repsPtr;

            CDDLL.ScanData scandata = new CDDLL.ScanData();
            scandata.fData = new float[1000];

            repsPtr = Marshal.AllocHGlobal(Marshal.SizeOf(typeof(CDDLL.ScanData)));
            //repsPtr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(CDDLL.ScanData)));
            Marshal.StructureToPtr(scandata, repsPtr, true);

            //int nStartCount = CDDLL.COMI_US_CurCount(g_hDevice);
            int nRetrvCount = CDDLL.COMI_US_RetrvChannel(g_hDevice, (int)CHLIST.CH0, 0, 1000, repsPtr, (int)CDDLL.TCdVarType.VT_FLOAT);

            CDDLL.ScanData reps = new CDDLL.ScanData();
            //reps.fData = new double[1000];

            reps = (CDDLL.ScanData)Marshal.PtrToStructure(repsPtr, typeof(CDDLL.ScanData));

            // reps.fData  ֽ 
            if (nRetrvCount > 0)
            {
                // ׷ ǥ
                axComiGraph1.DeletePlot(0);
                //axComiGraph1.PlotY(0, ref scandata.fData[0], 0, 1, nRetrvCount);
                axComiGraph1.UpdatePlot();
            }

            //Marshal.FreeCoTaskMem(repsPtr);
            Marshal.FreeHGlobal(repsPtr);
            */          
        }

        private void axComiDaq1_DigitalInStateChanged(object sender, AxCOMIDAQLib._DComiDaqEvents_DigitalInStateChangedEvent e)
        {

        }

        private void CmbRange_SelectedIndexChanged(object sender, EventArgs e)
        {
            float Vmin = 0, Vmax = 0;
            switch (CmbRange.SelectedIndex)
            {
                case 0:
                    Vmin = -1;
                    Vmax = 1;
                    break;

                case 1:
                    Vmin = -2;
                    Vmax = 2;
                    break;

                case 2:
                    Vmin = -5;
                    Vmax = 5;
                    break;

                case 3:
                    Vmin = -10;
                    Vmax = 10;
                    break;
            }

            for (int ch = 0; ch < CH_NUM; ch++)
            {
                CDDLL.COMI_AD_SetRange(g_hDevice, ch, Vmin, Vmax);
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            CDDLL.COMI_UnloadDevice(g_hDevice);
        }
    }
}
